<?php

namespace DecentThemes\Billing\Contracts\Provision;

interface Service
{
    /**
     * Create a new service.
     *
     * @param array $attributes
     *
     * @return bool
     */
    public function create(array $attributes = []): bool;

    /**
     * Update a service.
     *
     * @param string $name
     * @param array $attributes
     *
     * @return bool
     */
    public function update(string $name, array $attributes): bool;

    /**
     * Remove a service.
     *
     * @param string $name
     * @param array $options
     *
     * @return bool
     */
    public function remove(string $name, array $options = []): bool;

    /**
     * Get the information of a service.
     *
     * @param $name
     *
     * @return array
     */
    public function details($name): array;

    /**
     * Suspend a service.
     *
     * @param string $name
     * @param array $attributes
     *
     * @return bool
     */
    public function suspend(string $name, array $attributes = []): bool;

    /**
     * Unsuspend a service.
     *
     * @param string $name
     *
     * @return bool
     */
    public function unsuspend(string $name): bool;
}
