<?php

namespace DecentThemes\Billing\Contracts\Provision;

interface Server
{
    /**
     * Create a new server.
     *
     * @param array $attributes
     *
     * @return bool
     */
    public function create(array $attributes = []): bool;

    /**
     * Update a server.
     *
     * @param string $name
     * @param array $attributes
     *
     * @return bool
     */
    public function update(string $name, array $attributes): bool;

    /**
     * Remove a server.
     *
     * @param string $name
     * @param array $options
     *
     * @return bool
     */
    public function remove(string $name, array $options = []): bool;

    /**
     * Get the information of a server.
     *
     * @param string $name
     *
     * @return array
     */
    public function details(string $name): array;
}
