<?php

namespace DecentThemes\Billing\Contracts\Provision;

interface Hosting
{
    /**
     * Create a new hosting account.
     *
     * @param array $attributes
     *
     * @return bool
     */
    public function create(array $attributes = []): bool;

    /**
     * Update a hosting account.
     *
     * @param string $account
     * @param array $attributes
     *
     * @return bool
     */
    public function update(string $account, array $attributes): bool;

    /**
     * Suspends a hosting account.
     *
     * @param string $account
     * @param array $attributes
     *
     * @return bool
     */
    public function suspend(string $account, array $attributes = []): bool;

    /**
     * Unsuspend a hosting account.
     *
     * @param string $account
     *
     * @return bool
     */
    public function unsuspend(string $account): bool;

    /**
     * Terminates a hosting account.
     *
     * @param string $account
     * @param array $options
     *
     * @return bool
     */
    public function terminate(string $account, array $options = []): bool;

    /**
     * Get the information of a hosting account.
     *
     * @param string $account
     *
     * @return array
     */
    public function details(string $account): array;
}
