<?php

namespace DecentThemes\Billing\Contracts\Provision;

interface Domain
{
    /**
     * Get the name of the domain registry name.
     *
     * @return string
     */
    public function registry(): string;

    /**
     * Register a new domain.
     *
     * @param string $domain
     * @param int $years
     * @param array $attributes
     *
     * @return bool
     */
    public function register(string $domain, int $years = 1, array $attributes = []): bool;

    /**
     * Transfer a domain from another registrar.
     *
     * @param string $domain
     * @param int $years
     * @param array $attributes
     *
     * @return bool
     */
    public function transfer(string $domain, int $years = 1, array $attributes = []): bool;

    /**
     * Renew a domain.
     *
     * @param string $domain
     * @param int $years
     *
     * @return bool
     */
    public function renew(string $domain, int $years = 1): bool;

    /**
     * Suspends a domain.
     *
     * @param string $domain
     * @param string|null $reason
     *
     * @return bool
     */
    public function suspend(string $domain, ?string $reason = null): bool;

    /**
     * Unsuspend a domain.
     *
     * @param string $domain
     *
     * @return bool
     */
    public function unsuspend(string $domain): bool;

    /**
     * Update the nameservers of a domain.
     *
     * @param array $nameservers
     *
     * @return bool
     */
    public function updateNameservers(array $nameservers = []): bool;

    /**
     * Update the whois contact information of a domain.
     *
     * @param string $domain
     * @param $contact
     * @param $type
     *
     * @return bool
     */
    public function updateWhoisContact(string $domain, $contact = [], $type = 'registrant'): bool;

    /**
     * Get the details of a domain.
     *
     * @param $domain
     *
     * @return array
     */
    public function details($domain): array;

    /**
     * @param $domain
     *
     * @return string
     */
    public function authCode($domain): string;
}
