# Extensions for Laravel

This package allow laravel developers to make project with extension feature.


## Installation

Add this to your composer.json file

```json
{
  "repositories": [{
    "type": "composer",
    "url": "https://satis.aminul.work"
  }]
}
```

Run the following command to install the package
```bash
composer require aminuldigital/extensions
```

## Usage

Create new directory at your laravel projects root directory called: `extensions` and create a new directory for your extension. For example: `extensions/hello-world`.

Now you need to create new file with same as your directory name. For example: `extensions/hello-world/hello-world.php`. Put the following code in the file.

```php
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Support\Facades\Route;
use YourName\HelloWorld\HelloController;

return [
    'slug' => 'hello-world',
    'name' => 'Hello World',
    'version' => '1.0.0',
    'author' => 'Aminul Islam',
    'description' => 'A simple hello world extension for Laravel',
    'libs' => [
        'files' => [
            // TODO: make it usable
        ],
        'namespaces' => [
            'src' => 'YourName\\HelloWorld\\',
            'lib' => 'YourName\\HelloWorld\\Library\\',
        ],
    ],
    'boot' => function (Application $app) {
        Route::get('/hello', HelloController::class);
    },
    'register' => function (Application $app) {
        //
    },
];
```
That's it. Now you can use your extension by visiting `http://example.test/hello`.


Example directory structure:
```
├── extensions
│   ├── hello-world
│   │   ├── hello-world.php
│   │   ├── lib
│   │   │   └── CustomLibrary.php
│   │   └── src
│   │       ├── HelloController.php
│   │       └── HelloWorld.php
```
