<?php

namespace AminulBD\FreeRadius\MySql;

use Illuminate\Database\Connection;

readonly class User
{
    public function __construct(private Connection $db)
    {
        //
    }

    /**
     * @param string $username
     *
     * @return \stdClass|null
     */
    public function findByUsername(string $username): ?object
    {
        $checks = $this->db->table('radcheck')
            ->join('radusergroup', 'radcheck.username', '=', 'radusergroup.username')
            // ->join('radreply', 'radcheck.username', '=', 'radreply.username')
            ->where('radcheck.username', $username)
            ->get();

        if ($checks->isEmpty()) {
            return null;
        }

        $user = new \stdClass();
        foreach ($checks as $check) {
            $user->{$check->attribute} = $check->value;
        }

        $user->groupname = $checks[0]->groupname;

        return $user;
    }

    /**
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function insert(array $fields): bool
    {
        $username = $fields['Username'];
        $groupname = $fields['Group-Name'] ?? null;
        $options = $fields['options'] ?? [];

        unset($fields['Username'], $fields['Group-Name'], $fields['options']);

        if ($this->findByUsername($username)) {
            throw new \Exception('User already exists.');
        }

        $fields = array_map(fn ($key, $value) => [
            'username' => $username,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($fields), $fields);

        $added = $this->db->table('radcheck')->insert($fields);
        if (! $added) {
            return false;
        }

        $options = array_map(fn ($key, $value) => [
            'username' => $username,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($options), $options);
        $this->db->table('radreply')->insert($options);

        if ($groupname) {
            $this->db->table('radusergroup')->insert([
                'username' => $username,
                'groupname' => $groupname,
            ]);
        }

        return true;
    }

    /**
     * @param string $username
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function update(string $username, array $fields): bool
    {
        if (! $this->findByUsername($username)) {
            throw new \Exception('User not found.');
        }

        $groupname = $fields['Group-Name'] ?? null;
        $options = $fields['options'] ?? [];

        unset($fields['Group-Name'], $fields['options']);

        // delete old data
        $this->db->table('radreply')->where('username', $username)->delete();
        $this->db->table('radcheck')->where('username', $username)->delete();
        $this->db->table('radusergroup')->where('username', $username)->delete();

        // insert new data
        $added = $this->db->table('radcheck')->insert($fields);
        if (! $added) {
            return false;
        }

        $options = array_map(fn ($key, $value) => [
            'username' => $username,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($options), $options);
        $this->db->table('radreply')->insert($options);

        if (! empty($groupname)) {
            $this->db->table('radusergroup')->insert([
                'username' => $username,
                'groupname' => $groupname,
                'priority' => 1,
            ]);
        }

        return $added;
    }

    /**
     * @param string $username
     *
     * @return bool
     */
    public function delete(string $username): bool
    {
        $this->db->table('radcheck')->where('username', $username)->delete();
        $this->db->table('radreply')->where('username', $username)->delete();
        $this->db->table('radusergroup')->where('username', $username)->delete();

        return true;
    }
}
