<?php

namespace AminulBD\FreeRadius\MySql;

use Illuminate\Database\Connection;

readonly class Package
{
    /**
     * @param \Illuminate\Database\Connection $db
     */
    public function __construct(private Connection $db)
    {
    }

    /**
     * Find the package by the given groupname.
     *
     * @param string $groupname
     *
     * @return object|null
     */
    public function findByGroupName(string $groupname): ?object
    {
        $items = $this->db->table('radgroupreply')
            ->where('groupname', $groupname)
            ->get();

        if ($items->isEmpty()) {
            return null;
        }

        $group = new \stdClass();
        foreach ($items as $item) {
            $group->{$item->attribute} = $item->value;
        }

        return $group;
    }

    /**
     * Insert a new package.
     *
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function insert(array $fields): bool
    {
        $groupname = $fields['Group-Name'];
        unset($fields['Group-Name']);

        // if already exists
        if ($this->findByGroupName($groupname)) {
            throw new \Exception('Package already exists.');
        }


        $available = array_map(fn($key, $value) => [
            'groupname' => $groupname,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($fields), $fields);

        return $this->db->table('radgroupreply')->insert($available);
    }

    /**
     * Edit an existing package.
     *
     * @param string $groupName
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function update(string $groupName, array $fields): bool
    {
        $groupname = $fields['Group-Name'];
        unset($fields['Group-Name']);

        // if not exists
        if (!$this->findByGroupName($groupname)) {
            throw new \Exception('Package does not exists.');
        }

        $available = array_map(fn($key, $value) => [
            'groupname' => $groupname,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($fields), $fields);

        // delete old data
        $this->db->table('radgroupreply')->where('groupname', $groupName)->delete();

        // insert new data
        return $this->db->table('radgroupreply')->insert($available);
    }
}
