<?php

namespace AminulBD\FreeRadius;

use AminulBD\FreeRadius\MySql\Nas;
use AminulBD\FreeRadius\MySql\Package;
use AminulBD\FreeRadius\MySql\User;
use Illuminate\Support\Facades\DB;

class Manager
{
    /**
     * @var \AminulBD\FreeRadius\MySql\Nas
     */
    public Nas $nas;

    /**
     * @var \AminulBD\FreeRadius\MySql\Package
     */
    public Package $package;

    /**
     * @var \AminulBD\FreeRadius\MySql\User
     */
    public User $user;

    /**
     * Manager constructor.
     *
     * @throws \Exception
     */
    public function __construct()
    {
        $name = config('freeradius.mysql');
        if (!$name) {
            throw new \Exception('FreeRADIUS MySQL database connection not configured.');
        }

        $dbc = DB::connection($name);

        $this->nas = new Nas($dbc);
        $this->package = new Package($dbc);
        $this->user = new User($dbc);
    }

    public function user(): User
    {
        return $this->user;
    }

    public function nas(): Nas
    {
        return $this->nas;
    }

    public function package(): Package
    {
        return $this->package;
    }
}
