<?php

namespace AminulBD\FreeRadius\MySql;

use Illuminate\Database\Connection;
use Illuminate\Database\Query\Builder;

readonly class Package
{
    /**
     * @var \Illuminate\Database\Query\Builder
     */
    private Builder $table;

    /**
     * @param \Illuminate\Database\Connection $db
     */
    public function __construct(private Connection $db)
    {
        $this->table = $this->db->table('radgroupreply');
    }

    /**
     * @param string $groupname
     *
     * @return \stdClass|null
     */
    public function findByGroupName(string $groupname): ?object
    {
        $items = $this->table->where('groupname', $groupname)->get();

        if ($items->isEmpty()) {
            return null;
        }

        $group = new \stdClass();
        foreach ($items as $item) {
            $group->{$item->attribute} = $item->value;
        }

        return $group;
    }

    /**
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function insert(array $fields): bool
    {
        $groupname = $fields['Group-Name'];
        unset($fields['Group-Name']);

        // if already exists
        if ($this->findByGroupName($groupname)) {
            throw new \Exception('Package already exists.');
        }

        $available = array_map(fn ($key, $value) => [
            'groupname' => $groupname,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($fields), $fields);

        return $this->table->insert($available);
    }

    /**
     * @param string $groupName
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function update(string $groupName, array $fields): bool
    {
        $newName = $fields['Group-Name'];
        unset($fields['Group-Name']);

        // if not exists
        // if (! $this->findByGroupName($groupName)) {
        //     throw new \Exception('Package does not exists.');
        // }

        $available = array_map(fn ($key, $value) => [
            'groupname' => $newName,
            'attribute' => $key,
            'op' => ':=',
            'value' => $value,
        ], array_keys($fields), $fields);

        // delete old data
        $this->table->where('groupname', $groupName)->delete();

        // insert new data
        return $this->table->insert($available);
    }
}
