<?php

namespace AminulBD\FreeRadius;

use AminulBD\FreeRadius\MySql\Accounting;
use AminulBD\FreeRadius\MySql\Log;
use AminulBD\FreeRadius\MySql\Nas;
use AminulBD\FreeRadius\MySql\Package;
use AminulBD\FreeRadius\MySql\User;
use Illuminate\Support\Facades\DB;

class Manager
{
    public Nas $nas;

    public Package $package;

    public User $user;

    public Accounting $accounting;

    public Log $logs;

    /**
     * @throws \Exception
     */
    public function __construct()
    {
        $name = config('freeradius.mysql');
        if (! $name) {
            throw new \Exception('FreeRADIUS MySQL database connection not configured.');
        }

        $dbc = DB::connection($name);

        $this->nas = new Nas($dbc);
        $this->package = new Package($dbc);
        $this->user = new User($dbc);
        $this->accounting = new Accounting($dbc);
        $this->logs = new Log($dbc);
    }

    public function accounting()
    {
        return $this->accounting;
    }

    public function logs()
    {
        return $this->logs;
    }

    public function nas(): Nas
    {
        return $this->nas;
    }

    public function package(): Package
    {
        return $this->package;
    }

    public function user(): User
    {
        return $this->user;
    }
}
