<?php

namespace AminulBD\FreeRadius\MySql;

use Exception;
use Illuminate\Database\Connection;
use Illuminate\Database\Query\Builder;
use Illuminate\Support\Collection;

readonly class Nas
{
    /**
     * @var string[]
     */
    private array $fields;

    /**
     * @param \Illuminate\Database\Connection $db
     */
    public function __construct(private Connection $db)
    {
        $this->fields = [
            'nasname',
            'shortname',
            'type',
            'ports',
            'secret',
            'server',
            'community',
            'description',
        ];
    }

    /**
     * @var \Illuminate\Database\Query\Builder
     */
    public function query(): Builder
    {
        return $this->db->table('nas');
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function find(): Collection
    {
        return $this->query()->get();
    }

    /**
     * @param int $id
     *
     * @return object|null
     */
    public function findById(int $id): ?object
    {
        return $this->query()->where('id', $id)->first();
    }

    /**
     * @param string $name
     *
     * @return object|null
     */
    public function findByName(string $name): ?object
    {
        return $this->query()->where('nasname', $name)->first();
    }

    /**
     * @param array $data
     *
     * @return bool
     * @throws \Exception
     */
    public function insert(array $data): bool
    {
        if (empty($data['nasname'])) {
            throw new Exception('nasname is required.');
        }

        foreach ($data as $key => $value) {
            if (! in_array($key, $this->fields)) {
                throw new Exception("Invalid field: $key");
            }
        }

        if ($this->findByName($data['nasname'])) {
            throw new Exception('NAS already exists.');
        }

        return $this->query()->insert($data);
    }

    /**
     * @param int $id
     * @param array $data
     *
     * @return bool
     * @throws \Exception
     */
    public function update(int $id, array $data): bool
    {
        if (! $this->findById($id)) {
            throw new Exception('NAS not found.');
        }

        foreach ($data as $key => $value) {
            if (! in_array($key, $this->fields)) {
                throw new Exception("Invalid field: $key");
            }
        }

        return $this->query()->where('id', $id)->update($data);
    }

    /**
     * @param array $attributes
     * @param array $values
     *
     * @return bool
     * @throws \Exception
     */
    public function updateOrInsert(array $attributes, array $values = []): bool
    {
        if (empty($attributes['nasname']) && empty($attributes['id'])) {
            throw new Exception('nasname or id is required.');
        }

        $fields = array_merge($attributes, $values);
        foreach ($fields as $key => $value) {
            if (! in_array($key, $this->fields)) {
                throw new Exception("Invalid field: $key");
            }
        }

        return $this->query()->updateOrInsert($attributes, $values);
    }

    /**
     * @param int $id
     *
     * @return bool
     */
    public function delete(int $id): bool
    {
        return $this->query()->where('id', $id)->delete();
    }
}
