<?php

namespace AminulBD\FreeRadius\MySql;

use Illuminate\Database\Connection;
use Illuminate\Support\Collection;

readonly class Nas
{
    public function __construct(private Connection $db)
    {
        //
    }

    public function find(): Collection
    {
        return $this->db->table('nas')->get();
    }

    public function findById(int $id): ?object
    {
        return $this->db->table('nas')->where('id', $id)->first();
    }

    /**
     * @param string $name
     *
     * @return object|null
     */
    public function findByName(string $name): ?object
    {
        return $this->db->table('nas')->where('nasname', $name)->first();
    }

    /**
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function insert(array $fields): bool
    {
        if ($this->findByName($fields['nasname'])) {
            throw new \Exception('NAS already exists.');
        }

        return $this->db->table('nas')->insert($fields);
    }

    /**
     * @param int $id
     * @param array $fields
     *
     * @return bool
     * @throws \Exception
     */
    public function update(int $id, array $fields): bool
    {
        if (! $this->findById($id)) {
            throw new \Exception('NAS not found.');
        }

        return $this->db->table('nas')->where('id', $id)->update($fields);
    }

    /**
     * @param int $id
     *
     * @return bool
     */
    public function delete(int $id): bool
    {
        return $this->db->table('nas')->where('id', $id)->delete();
    }
}
