<?php

namespace AminulBD\FreeRadius;

use Illuminate\Support\ServiceProvider;

class FreeRadiusServiceProvider extends ServiceProvider
{
    /**
     * @return void
     */
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/freeradius.php', 'freeradius');

        // singleton
        $this->app->singleton('freeradius', fn() => new Manager());
    }

    /**
     * @return void
     */
    public function boot(): void
    {
        $this->publishes([
            __DIR__ . '/../config/freeradius.php' => config_path('freeradius.php'),
        ], 'config');
    }
}
