<?php

namespace AminulBD\FreeRadius;

use AminulBD\FreeRadius\MySql\Nas;
use AminulBD\FreeRadius\MySql\Package;
use AminulBD\FreeRadius\MySql\User;
use Illuminate\Support\Facades\DB;

class Manager
{
    public Nas $nas;

    public Package $package;

    public User $user;

    /**
     * @throws \Exception
     */
    public function __construct()
    {
        $name = config('freeradius.mysql');
        if (! $name) {
            throw new \Exception('FreeRADIUS MySQL database connection not configured.');
        }

        $dbc = DB::connection($name);

        $this->nas = new Nas($dbc);
        $this->package = new Package($dbc);
        $this->user = new User($dbc);
    }

    public function user(): User
    {
        return $this->user;
    }

    public function nas(): Nas
    {
        return $this->nas;
    }

    public function package(): Package
    {
        return $this->package;
    }
}
